﻿<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie PIT-8B</title>
		<script runat="server">

    public class Params: ContextBase {
        
        public Params(Context context): base(context) {
            InitRok();
        }
    
        void InitRok() {
            Date data = Date.MinValue;
            if (Context.Contains(typeof(ActualDate)))
                data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
            if (data==Date.MinValue || data==Date.MaxValue)
                data = Date.Today;
            rok = data.Month<12 ? data.Year-1 : data.Year;
            info50 = false;
        }
    
        int rok;
        [Required]
        [Priority(1)]
        public int Rok {
            get { return rok; }
            set {
                rok = value;
                if (rok==0)
                    InitRok();
                OnChanged(EventArgs.Empty);
            }
        }
    
        bool podzial;
        [Priority(2)]
        [Caption("Podział na urzędy skarb.")]
        public bool Podzial {
            get { return podzial; }
            set {
                podzial = value;
                OnChanged(EventArgs.Empty);
            }
        }

        UrzadSkarbowy urzad;
        [Priority(3)]
        public UrzadSkarbowy Urzad {
            get { return urzad; }
            set {
                urzad = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public bool IsReadOnlyUrzad() {
            return !podzial;
        }

        bool info50;
        [Priority(4)]
        [Caption("Informacje o 50% KUP")]
        public bool Info50 {
            get { return info50; }
            set {
                info50 = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
    
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }
    
    class Podatnik {
        readonly Pracownik pracownik;
        readonly UrzadSkarbowy urzad;
        readonly FromTo okres;
    
        readonly string nazwiskoImie;
    
        readonly decimal przychod;
        readonly decimal przychodNieop;
        readonly decimal koszty;
        readonly decimal zaliczka;
        readonly decimal zus;
        readonly decimal korektaZus;
        readonly decimal pobrane;
        readonly decimal doOdliczenia;
        readonly decimal przychod50;
        readonly decimal koszty50;
        readonly decimal koszty50um;

        public Podatnik(ArrayList lista) {
            nazwiskoImie = "Suma:";
            foreach (UrzadSk us in lista)
                foreach (Podatnik pod in us.Podatnicy) {
                    przychod += pod.Przychod;
                    przychodNieop += pod.PrzychodNieop;
                    koszty += pod.Koszty;
                    zaliczka += pod.Zaliczka;
                    zus += pod.ZUS;
                    pobrane += pod.Pobrane;
                    doOdliczenia += pod.DoOdliczenia;
                    przychod50 += pod.Przychod50;
                    koszty50 += pod.Koszty50;
                    koszty50um += pod.Koszty50um;
                }
        }

        public Podatnik(Pracownik pracownik, FromTo okres, FromTo minokres, bool uwzględniajSkładkiZPIT8AR) {            
            this.pracownik = pracownik;
            PracHistoria ph = pracownik[okres.To];
    
            urzad = (UrzadSkarbowy)ph.Podatki.UrzadSkarbowy;
            nazwiskoImie = ph.Nazwisko + " " + ph.Imie;

            bool wszystkoNaPIT11 = okres.To.Year>=2007 || DeklaracjeModule.GetInstance(pracownik).Config.PIT.PIT11.WszystkieUmowyPIT8B && PracownikEtatowy(Pracownik, okres);

            //if (wszystkoNaPIT11)
            //    okres = FromTo.Year(okres.To.Year);

            SubTable wypłaty = new SubTable(pracownik.Wyplaty, okres);
            foreach (Soneta.Place.Wyplata wyplata in wypłaty)
                if (wszystkoNaPIT11 || (wyplata.Typ == TypWyplaty.Etat || wyplata.Typ == TypWyplaty.Inne || wyplata.Typ == TypWyplaty.Umowa && Pasuje(wyplata)))
                    foreach (WypElement element in wyplata.Elementy) {
                        bool zgodnyZUS = ZgodnyZUS(element, okres);
                        DefinicjaElementu definicja = element.Definicja;
                        PozycjaPIT pozpit = definicja.Deklaracje.PozycjaPIT;
                        if (pozpit != null) {
                            if (pozpit.PIT11 > 0 || pozpit.PIT8C != 100) {
                                bool podatek = element.Podatek;
                                if (!podatek || uwzględniajSkładkiZPIT8AR) {
                                    //if (!podatek) {
                                        if (element.ZaliczkaPodatku) {
                                            przychod += element.DoOpodatkowania;
                                            zaliczka += element.Podatki.ZalFIS;
                                        }
                                        koszty += element.Podatki.Koszty + element.Podatki.Koszty50;
                                        przychod50 += element.Podatki.Przychod50;
                                        koszty50 += element.Podatki.Koszty50;
                                        if (wyplata is WyplataUmowa) {
                                            decimal koszt50 = 0;
                                            switch (element.Definicja.Deklaracje.Koszty.Typ) {
                                                case TypKosztowUzyskaniaPrzychodu.Procentowe:
                                                case TypKosztowUzyskaniaPrzychodu.Procentowe50:
                                                case TypKosztowUzyskaniaPrzychodu.ProcentoweWarunkowo:
                                                    if (element.Definicja.Deklaracje.Koszty.Procent == new Percent(0.5M)) {
                                                        if (element.Podatki.Koszty > 0)
                                                            koszt50 = element.Podatki.Koszty;
                                                        else
                                                            koszt50 = element.Podatki.Koszty50;
                                                    }
                                                    else
                                                        koszt50 = element.Podatki.Koszty50;
                                                    break;
                                                default:
                                                    koszt50 = element.Podatki.Koszty50;
                                                    break;
                                            }
                                            koszty50um += koszt50;
                                        }
                                    //}

                                    if (zgodnyZUS)
                                        zus += element.Podatki.KosztyZUS;
                                    else
                                        korektaZus += element.Podatki.KosztyZUS;
                                    
                                    pobrane += element.Podatki.Zdrowotna.Prac;
                                    doOdliczenia += element.Podatki.ZdrowotneDoOdliczenia;

                                    Date data = element.Data;
                                    if (minokres == FromTo.Empty)
                                        minokres = new FromTo(data, data);
                                    else if (data < minokres.From)
                                        minokres = new FromTo(data, minokres.To);
                                    else if (data > minokres.To)
                                        minokres = new FromTo(minokres.From, data);
                                }
                            }
                        }
                    }
            foreach (Soneta.Place.Wyplata wyplata in wypłaty)
                foreach (WypElement element in wyplata.Elementy) {
                    DefinicjaElementu definicja = element.Definicja;
                    PozycjaPIT pozpit = definicja.Deklaracje.PozycjaPIT;
                    if (pozpit != null) {
                        if (pozpit.PIT8C == 100)
                            przychodNieop += element.Wartosc;
                        else if (pozpit.PIT8C == 10)
                            przychodNieop += element.NiePodlegaOpodatkowaniu;
                    }
                }
            
            this.okres = minokres;
        }

        static bool ZgodnyZUS(WypElement e, FromTo okres) {
            Debug.Assert(okres == FromTo.Empty || okres.Contains(e.Data));
            return e.MiesiacDeklaracji == e.MiesiacZUS || okres != FromTo.Empty && new YearMonth(okres.From) <= e.MiesiacZUS && e.MiesiacZUS <= new YearMonth(okres.To);
        }

        bool PracownikEtatowy(Pracownik p, FromTo okres) {
            Debug.Assert(okres == FromTo.Year(okres.To.Year));
            foreach (PracHistoria ph in p.Historia.GetIntersectedRows(okres))
                if (ph.Etat.EfektywnyOkres * okres != FromTo.Empty)
                    return true;
            return false;
        }
        
        bool Pasuje(Wyplata wyplata) {
            Date data = wyplata.Data;
            PracHistoria historia = wyplata.Pracownik[data];
            return historia.Etat.EfektywnyOkres.Contains(data);
        }
    
        public string NazwiskoImieOkres {
            get { return nazwiskoImie + (okres != FromTo.Empty ? "<br>" + okres.ToString() : ""); }
        }
        public FromTo Okres {
            get { return okres; }
        }
        public Pracownik Pracownik {
            get { return pracownik; }
        }
        public UrzadSkarbowy Urzad {
            get { return urzad; }
        }
        public decimal Przychod {
            get {
                if (korektaZus < 0)
                    return przychod - korektaZus;
                return przychod;
            }
        }
        public decimal PrzychodNieop {
            get { return przychodNieop; }
        }
        public decimal Koszty {
            get { return koszty; }
        }
        public decimal Dochod {
            get { return Przychod-koszty; }
        }
        public decimal Zaliczka {
            get { return zaliczka; }
        }
        public decimal Przychod50 {
            get { return przychod50; }
        }
        public decimal Koszty50 {
            get { return koszty50; }
        }
        public decimal ZUS {
            get {
                if (korektaZus < 0)
                    return zus;
                return zus + korektaZus;                            
            }
        }
        public decimal Pobrane {
            get { return pobrane; }
        }
        public decimal DoOdliczenia {
            get { return doOdliczenia; }
        }
        public decimal Koszty50um {
            get { return koszty50um; }
        }
    }
    
    class UrzadSk: IComparable {
        readonly UrzadSkarbowy urzad;
        readonly ArrayList podatnicy = new ArrayList();
    
        public UrzadSk(UrzadSkarbowy urzad) {
            this.urzad = urzad;
        }
        public void Add(Podatnik podatnik) {
            podatnicy.Add(podatnik);
        }
        public UrzadSkarbowy Urzad {
            get { return urzad; }
        }
        public IEnumerable Podatnicy {
            get { return podatnicy; }
        }
    
        int IComparable.CompareTo(object v) {
            if (v==null)
                return 1;
            UrzadSk us = v as UrzadSk;
            if (us==null)
                throw new ArgumentException();
            if (urzad==null)
                return us.urzad==null ? 0 : -1;
            if (us.urzad==null)
                return 1;
            return urzad.Nazwa.CompareTo(us.urzad.Nazwa);
        }
    }
    
    Hashtable urzedy = new Hashtable();
		    
    void dc_ContextLoad(Object sender, EventArgs e) {
        dc.Landscape = Pars.Info50;

        bool jednaDeklaracja = DeklaracjeModule.GetInstance(dc).Config.PIT.PIT11.NaliczanieSeryjneZaCałyRok;
        bool uwzględniajSkładkiZPIT8AR = DeklaracjeModule.GetInstance(dc).Config.PIT.PIT11.UwzględniajSkładkiZPIT8AR;
        
        ReportHeader["ROK"] = pars.Rok.ToString();
        ReportHeader["URZAD"] = pars.Urzad==null ? "(wszystkie)" : pars.Urzad.Nazwa;
        ReportHeader["SKŁADKI"] = uwzględniajSkładkiZPIT8AR ? "|Uwzględniono składki od przychodów wykazywanych na PIT-8AR" : "";
    
        FromTo rok = FromTo.Year(pars.Rok);
    
        Row[] rows = (Row[])dc[typeof(Row[])];
        foreach (Pracownik idx in rows) {
            Periods per = Periods.Empty;
            foreach (PracHistoria ph in idx.Historia.GetIntersectedRows(rok))
                per += ph.Etat.EfektywnyOkres;
    
            per = per.ToFlat()*rok;
            if (per==Periods.Empty)
                Wylicz(idx, rok, FromTo.Empty, uwzględniajSkładkiZPIT8AR);
            else if (jednaDeklaracja)
                Wylicz(idx, rok, new FromTo(per.From, per.To), uwzględniajSkładkiZPIT8AR);
            else {
                Date start = rok.From;
                for (int i = 0; i < per.Count; i++) {
                    FromTo minokres = per[i];
                    FromTo okres = new FromTo(start, i == per.Count - 1 ? rok.To : per[i + 1].From - 1);
                    Wylicz(idx, okres, minokres, uwzględniajSkładkiZPIT8AR);
                    start = okres.To + 1;
                }
            }
        }

        p50.Visible = k50.Visible = k50um.Visible = pars.Info50;
        
        ArrayList lista = new ArrayList(urzedy.Values);
        lista.Sort();
        if (lista.Count > 1 && pars.Podzial) {
            object key = (object)2;
            UrzadSk urzad = new UrzadSk(null);
            urzedy[key] = urzad;
            urzad.Add(new Podatnik(lista));
            lista.Add(urzad);
        }
    
        DataRepeater1.DataSource = lista;
    }
    
    void Wylicz(Pracownik pracownik, FromTo okres, FromTo minokres, bool uwzględniajSkładkiZPIT8AR) {
        Podatnik pod = new Podatnik(pracownik, okres, minokres, uwzględniajSkładkiZPIT8AR);
        if (pod.Przychod>0m || pod.PrzychodNieop>0m || pod.Pobrane>0m) {
            UrzadSkarbowy us = !pars.Podzial ? null : pod.Urzad;
            if (pars.Urzad==null || pars.Urzad==us) {
                object key = us!=null ? (object)us : (object)1;
                UrzadSk urzad = (UrzadSk)urzedy[key];
                if (urzad==null)
                    urzedy[key] = urzad = new UrzadSk(us);
                urzad.Add(pod);
            }
        }
    }

    void DataRepeater1_OnBeforeRow(Object sender, EventArgs args) {
        UrzadSk us = (UrzadSk)DataRepeater1.CurrentRow;
		if (pars.Podzial && us.Urzad==null) {
            colNazwiskoImieOkres.Caption = "Podsumowanie";
            colNazwiskoImieOkres.Align = System.Web.UI.WebControls.HorizontalAlign.Center;
            Grid1.ShowSum = Soneta.Web.GridSumMode.Never;
        }
    }

        public static void Msg(object obj) {
        }

		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Zestawienie PIT-11|&lt;/strong&gt;Rok:&lt;strong&gt; %ROK%|&lt;/strong&gt;Urząd skarbowy:&lt;strong&gt; %URZAD%&lt;/strong&gt;%SKŁADKI%"
				runat="server"></eb:ReportHeader>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%" onbeforerow="DataRepeater1_OnBeforeRow">
				<P>
					<ea:DataLabel id="dlUrzadSkarbowy" runat="server" DataMember="Urzad.Nazwa"></ea:DataLabel><BR>
					<ea:Grid id="Grid1" runat="server" DataMember="Podatnicy">
						<Columns>
							<ea:GridColumn ID="colLp" Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
							<ea:GridColumn ID="colNazwiskoImieOkres" Width="28" DataMember="NazwiskoImieOkres" Total="Info" Caption="Nazwisko i imię&lt;br&gt;Okres"></ea:GridColumn>
							<ea:GridColumn ID="colPrzychod" Width="12" Align="Right" DataMember="Przychod" Total="Sum" Caption="Przych&#243;d opodatk." Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn ID="colPrzychodNieop" Width="12" Align="Right" DataMember="PrzychodNieop" Total="Sum" Caption="Przych&#243;d nieopodatk." Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn ID="colKoszty" Align="Right" DataMember="Koszty" Total="Sum" Caption="Koszty uzyskania razem" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" ID="p50" DataMember="Przychod50" Total="Sum" Caption="Przychód<br/>50% KUP etat" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" ID="k50" DataMember="Koszty50" Total="Sum" Caption="50% KUP etat" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Align="Right" ID="k50um" DataMember="Koszty50um" Total="Sum" Caption="Koszty 50% um.cywil." Format="{0:n}"></ea:GridColumn>
                            <ea:GridColumn ID="colDochod" Width="12" Align="Right" DataMember="Dochod" Total="Sum" Caption="Doch&#243;d" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn ID="colZaliczka" Align="Right" DataMember="Zaliczka" Total="Sum" Caption="Pobrana zaliczka" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn ID="colZUS" Align="Right" DataMember="ZUS" Total="Sum" Caption="Skł. ub. społeczne" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn ID="colPobrane" Align="Right" DataMember="Pobrane" Total="Sum" Caption="Skł. ub. zdrowotne~pobrana" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn ID="colDoOdliczenia" Align="Right" DataMember="DoOdliczenia" Total="Sum" Caption="Skł. ub. zdrowotne~do odliczenia" Format="{0:n}"></ea:GridColumn>
						</Columns>
					</ea:Grid></P>
			</ea:DataRepeater>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</HTML>
